function [obj, errmsg] = vb_batch_parm_set_set_parm(obj, ix, parm, parm_type)
% Set parameter to the specified index.
%
% [USAGE]
%    [parm, parm_type] = vb_batch_parm_set_set_parm(<obj>, <ix>);
% [IN]
%          obj : vb_batch_parm_set object
%           ix : index of the parameter set.
%         parm : to be added parameter to the set
%    parm_type : parameter type such as 'brain_parm', 'head_parm',.. [STRING]
% [OUT]
%       obj : vb_batch_parm_set object
%    errmsg : if error occured, the reason will be containd.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

%
% --- Main Procedure
%
errmsg = [];

try
    obj.list{ix, 1} = parm;
    obj.list{ix, 2} = parm_type;
catch
    errmsg = 'specified index is invalid.';
    warning(errmsg);
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_parm_set object');
end
