function [obj] = vb_batch_mgr_set_name(obj, name)
% Change name of batch manager.
% [USAGE]
%    [obj] = vb_batch_mgr_set_name(<obj>, <name>);
% [IN]
%     obj : vb_batch_mgr object
%    name : batch manager name
% [OUT]
%    obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('name', 'var')
    error('name is a required parameter.');
end

%
% --- Main Procedure
%
obj.name = name;

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_mgr object.');
end

