function [obj, errmsg] = vb_batch_mgr_add_varable(obj, variable_name)
% Add variable name to the table
%
% [USAGE]
%    [obj, errmsg] = vb_batch_mgr_add_varable(<obj, <variable_name>);
% [IN]
%              obj : vb_batch_mgr object
%    variable_name : variable name such as '$ID$', '$SUBJ$' [STRING]
% [OUT]
%       obj : vb_batch_mgr object
%    errmsg : If error is occured, the reason will be contained.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('variable_name', 'var')
    error('obj is a required parameter.');
end
if ~ischar(variable_name) || isempty(variable_name)
    error('variable name is invalid');
end

%
% --- Main Procedure
%

% Add variable
[obj.table, errmsg] = ...
    vb_batch_variable_table_add_column(obj.table, variable_name);

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
