function [obj] = vb_batch_mgr_set_parm_set(obj, ix, parm_set)
% set parameter set.
% This is inner private function.(utility)
% [USAGE]
%    [obj] = vb_batch_mgr_get_focus_parm_set(<obj>, <ix>, <parm_set>);
% [IN]
%         obj : vb_batch_mgr object
%          ix : index for focusing on parameter set. [INTEGER]
%                = 0 : template parameter set.
%                >=1 : batch parameter set.
%    parm_set : parameter set(vb_batch_parm_set object)
% [OUT]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end
if ix < 0
    error('Invalid index is specified. maybe bug of the program');
end

if ~exist('parm_set', 'var')
    error('parm_set is a required parameter.');
end

%
% --- Main Procedure
%
if ix == 0
    obj.template = parm_set;
else
    obj.parm_set{ix} = parm_set;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
