function vb_batch_list_update_variable_listbox(fig)
% update variable listbox.
% [USAGE]
%    vb_batch_list_update_variable_listbox(<fig>);
% [IN]
%    fig : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
data = guidata(fig);

[variable_list, table] = vb_batch_mgr_get_table_data(data.bmgr);
set(data.H.variable_listbox, 'String', variable_list);

% Adjust selected line number
line_no = get(data.H.variable_listbox, 'Value');
Nvalue = length(variable_list);
if Nvalue < 1
    line_no = 1;
elseif line_no > Nvalue
    line_no = Nvalue;
end
set(data.H.variable_listbox, 'Value', line_no);


% Set the number of parameter set to be created.
Nrow = size(table, 1);
set(data.H.Nparm_set_text, 'String', num2str(Nrow));

% Component Enable/Disable
components = [data.H.variable_rename_push;
              data.H.variable_remove_push
              data.H.edit_table_push];
if Nvalue
    set(components, 'Enable', 'on');
else
    set(components, 'Enable', 'off');
end
