function vb_batch_list_update_concreate_parm_id_listbox(fig)
% update concrete parameter id listbox
%
% [USAGE]
%    vb_batch_list_update_concrete_parm_id_listbox(<fig>);
% [IN]
%    fig : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
data = guidata(fig);

Nparm_set = vb_batch_mgr_get_num_of_parm_set(data.bmgr);

% make name list of parameter set
listbox_str = cell(0);
ix_sub = [];
for k=1:Nparm_set
    ix_main = k;
    [p, p_type, set_name] = ...
            vb_batch_mgr_get_parm(data.bmgr, ix_main, ix_sub);
    listbox_str{k, 1} = set_name;
end

% set name list to listbox
set(data.H.concrete_parm_id_listbox, 'String', listbox_str);

% update concrete parameter listbox
vb_batch_list_update_concrete_parm_listbox(fig);
