function bayes_parm = vb_set_noise_estimation_model(bayes_parm, proj_root)
% Set noise estimation model
%  bayes_parm = vb_set_noise_estimation_model(bayes_parm, proj_root)
% --- Input field
% Noise estimation model is determined according to the following fields
%    bayes_parm.forward_model
%    bayes_parm.noise_estimation_model
%    bayes_parm.soft_mode
%    
% --- Output field
%
% --- Noise estimation model
% bayes_parm.megnoisefile   % MEG sensor noise file
% bayes_parm.twin_noise     % Noise estimation time window
% bayes_parm.twin_global    % Baseline activity estimation time window
% bayes_parm.noise_model    % Covariance noise matrix
% bayes_parm.update_sx      % sensor noise update flag
% bayes_parm.update_v       % current baseline update flag
% bayes_parm.flag_baseline  % sensor noise estimation flag
% bayes_parm.flag_noise_set % current baseline estimation flag
% --- Global window
% bayes_parm.basisfile_global 
% bayes_parm.area_key_global 
% bayes_parm.Rfilt_global    
% --- Soft normal constraint
% bayes_parm.variance_orientation 
% 
% --- Possible noise_estimation_model
% 'COVARIANCE NOISE' : forward_model = 'focal' or 'focal+global'
%        sx0 = pretriger noise
%        current baseline estimation together with sensor noise estimation
% = 1 :  update_sx = ON,  update_v = OFF  - Default for 'focal'
% = 2 :  update_sx = OFF, update_v = OFF  (NO UPDATE)
%
% 'ISOTROPIC NOISE'  : forward_model = 'focal+global'
%        sx0 = estimated noise with current baseline
%        current baseline estimation together with sensor noise estimation
% = 3 :  update_sx = ON,  update_v = ON   - Default for 'focal+global'
% = 4 :  update_sx = ON,  update_v = OFF  (NO GLOBAL UPDATE)
% = 5 :  update_sx = OFF, update_v = OFF  (NO UPDATE)
%
% 'FIXED NOISE'      : forward_model = 'focal+global'
%        sx0 = pretriger noise
%        current baseline estimation  with fixed sensor noise
% = 6 :  update_sx = OFF, update_v = ON
% = 7 :  update_sx = OFF, update_v = OFF  (NO UPDATE)
%
% [history]
% vbmeg-0.45 M. Sato , 2005-8-31
% 2011-06-20 taku-y
%  [debug]: megfile -> megfile_baseline in 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin == 1
    proj_root = [];
end

%% --- Global window
if ~isfield(bayes_parm,'basisfile_global') ...
      | isempty(bayes_parm.basisfile_global)
  bayes_parm.basisfile_global = bayes_parm.basisfile;
end

switch	bayes_parm.forward_model 
 case	'focal+global'
  if ~isfield(bayes_parm,'area_key_global') ...
        | isempty(bayes_parm.area_key_global)
    bayes_parm.area_key_global = ['Cortex'];
  end
  if ~isfield(bayes_parm,'Rfilt_global') ...
        | isempty(bayes_parm.Rfilt_global)
    bayes_parm.Rfilt_global    = 0;
  end
 case	'focal'
  bayes_parm.area_key_global = bayes_parm.area_key;
  bayes_parm.Rfilt_global    = bayes_parm.Rfilt;
end

%% --- Soft normal constraint
if bayes_parm.soft_mode == 1,
  bayes_parm.variance_orientation = ON;  
else
  bayes_parm.variance_orientation = OFF;  
end

%% --- Noise_estimation_model
switch bayes_parm.noise_estimation_model
case {1,2},
 % 'COVARIANCE NOISE'
 % Mainly used in focal model
	
 %bayes_parm.megnoisefile = [bayes_parm.megfile]; 
 %bayes_parm.megfile_baseline = [bayes_parm.megfile]; 
 MEGinfo = vb_load_meg_info(fullfile(proj_root, bayes_parm.megfile{1}));
    
 % Noise estimation time window
 if ~isfield(bayes_parm, 'twin_noise')|isempty(bayes_parm.twin_noise)
   bayes_parm.twin_noise  = [1, MEGinfo.Pretrigger];
 end
 % Baseline activity estimation time window
 %if ~isfield(bayes_parm, 'twin_global')|isempty(bayes_parm.twin_global)
 %	bayes_parm.twin_global = [1, MEGinfo.Pretrigger];
 %end
 if ~isfield(bayes_parm, 'twin_baseline')|isempty(bayes_parm.twin_baseline)
   bayes_parm.twin_baseline = [1, MEGinfo.Pretrigger];
 end

 % Covariance noise matrix
 bayes_parm.noise_model = 3;
 % current baseline estimation together with sensor noise estimation
 bayes_parm.flag_baseline  = 0;
 % sx0 = pretriger noise
 bayes_parm.flag_noise_set = 0;

 % update flag
 switch bayes_parm.noise_estimation_model
  case	1
   bayes_parm.update_sx = ON;
   bayes_parm.update_v  = OFF;
  case	2
   % (NO UPDATE)
   bayes_parm.update_sx = OFF; 
   bayes_parm.update_v  = OFF;
 end
 case {3,4,5},
  % 'ISOTROPIC NOISE'
  % Mainly used in focal+global model
	
  %bayes_parm.megnoisefile = [bayes_parm.megfile]; 
  %bayes_parm.megfile_baseline = [bayes_parm.megfile]; 
  MEGinfo = vb_load_meg_info(fullfile(proj_root, bayes_parm.megfile{1}));
  % Noise estimation time window
  if ~isfield(bayes_parm, 'twin_noise')|isempty(bayes_parm.twin_noise)
    bayes_parm.twin_noise  = [1, MEGinfo.Pretrigger];
  end
  % Baseline activity estimation time window
  %if ~isfield(bayes_parm, 'twin_global')|isempty(bayes_parm.twin_global)
  %	bayes_parm.twin_global = [1, MEGinfo.Pretrigger];
  %end
  if ~isfield(bayes_parm, 'twin_baseline')|isempty(bayes_parm.twin_baseline)
    bayes_parm.twin_baseline = [1, MEGinfo.Pretrigger];
  end

  % Identity noise matrix
  bayes_parm.noise_model = 1;
  % current baseline estimation together with sensor noise estimation
  bayes_parm.flag_baseline  = 0;
  % sx0 = estimated noise with current baseline
  bayes_parm.flag_noise_set = 1; 
    
  % update flag
  switch bayes_parm.noise_estimation_model
   case	3
    bayes_parm.update_sx = ON;
    bayes_parm.update_v  = ON;
   case	4
    % (NO GLOBAL UPDATE)
    bayes_parm.update_sx = ON;
    bayes_parm.update_v  = OFF;
   case	5
    % (NO UPDATE)
    bayes_parm.update_sx = OFF; 
    bayes_parm.update_v  = OFF;
  end
 case {6,7},	
  % 'FIXED NOISE'
  % Only for focal+global model
	
  %if ~isfield(bayes_parm,'megnoisefile') ...
  %   | isempty(bayes_parm.megnoisefile),
  %  error('Please specify the file for observation noise specification');
  %end
  if ~isfield(bayes_parm,'megfile_baseline') ...
        | isempty(bayes_parm.megfile_baseline),
    error('Please specify the file for observation noise specification');
  end
  if bayes_parm.forward_model ~= 'focal+global',
    error('forward_model should be focal+global in SUPPLY NOISE FILE');
  end

  % Noise estimation time window
  %MEGinfo = vb_load_meg_info([proj_root filesep bayes_parm.megnoisefile{1}]);
  MEGinfo = vb_load_meg_info(fullfile(proj_root, bayes_parm.megfile_baseline{1}));
  if ~isfield(bayes_parm, 'twin_noise')|isempty(bayes_parm.twin_noise)
    bayes_parm.twin_noise = [1, MEGinfo.Nsample];
  end
  % Baseline activity estimation time window
  MEGinfo = vb_load_meg_info(fullfile(proj_root, bayes_parm.megfile{1}));
  %if ~isfield(bayes_parm, 'twin_global')|isempty(bayes_parm.twin_global)
  %	bayes_parm.twin_global = [1, MEGinfo.Pretrigger];
  %end
  if ~isfield(bayes_parm, 'twin_baseline')|isempty(bayes_parm.twin_baseline)
    bayes_parm.twin_baseline = [1, MEGinfo.Pretrigger];
  end
    
  % Covariance noise matrix
  bayes_parm.noise_model = 3;
  % current baseline estimation  with fixed sensor noise
  bayes_parm.flag_baseline  = 1;
  % sx0 = pretriger noise
  bayes_parm.flag_noise_set = 0; % ?? current setting = 1 ??

  % update flag
  switch bayes_parm.noise_estimation_model
   case	6,
    bayes_parm.update_sx = OFF;
    bayes_parm.update_v  = ON;
   case	7,	
    % (NO UPDATE)
    bayes_parm.update_sx = OFF; 
    bayes_parm.update_v  = OFF;
  end
 otherwise
  error('No such options');
end

return;