function	vb_parm = vb_set_multiple_prior(bayes_parm,vb_parm,ix)
% Set (multiple) fMRI activity pattern(s) for Bayes Wiener estimate
%  vb_parm = vb_set_multiple_prior(bayes_parm,vb_parm,ix)
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp('Set fMRI activity pattern for Bayesian Wiener estimate'); 

Nvact   = length(ix);
Norient = vb_parm.Norient;

% fMRI activity pattern
brainfile = bayes_parm.brainfile;
actfile   = bayes_parm.actfile;
act_key   = bayes_parm.act_key;

if iscell(act_key),
	Nact_key = length(act_key);
else
	act_key  = {act_key};
	Nact_key = 1;
end

fprintf('Nact_key   = %d\n',Nact_key)

% Set multiple fMRI activity pattern to act_ptn
act_ptn  = zeros(Nvact*Norient, Nact_key );

if ~isempty(ix)
	for n=1:Nact_key,
	    act = vb_get_act(actfile, act_key{n});
	    xxP = act.xxP/max(act.xxP);
	    xxP = xxP(ix).^2;
	    
		% Check current orientation
		if Norient==3 & vb_parm.soft_mode == 1,
			% Soft constraint on current orientation
		    disp('Soft constraint on current orientation'); 
			xxdev = vb_cortex_normal_variance(brainfile,[],[],vb_parm,'subj');
		    atmp  = repmat(xxP,[1 3]).*xxdev(ix,:);
		else
		    atmp  = repmat(xxP,[1 Norient]);
		end
		
	    act_ptn(:,n) = atmp(:);
	end
end

vb_parm.act = act_ptn;

return
