function   [weight ,Tindex, Nindex, Nsample] = ...
                vb_overlapped_timewindow_weight(Twindow, Tsample, tsubsamp, mode)
% Temporal smoothing window function
% [weight ,Tindex, Nindex]= ...
%        vb_overlapped_timewindow_weight(Twindow, Tsample, tsubsamp, mode)
% --- Input
% Twindow(n,:) = [Tstart(n), Tend(n)] : Start and end for n-th time window
% Tsample  : Total time sample number in MEG data
% tsubsamp : subsampled time index
% if tsubsamp = [], tsubsamp = 1:Tsample
% mode = 0 : weighted average
%      = 1 : non-overlapped concatenation is done
%            current time series of each time windows are concatenated
% --- Output
% Tindex{n} : n-th window time index in the absolute time index
% Nindex{n} : n-th window time index within the subsampled data
% weight{n} : n-th window weight for window average
% Nsample   : # of time sample for calculation
%
% Modified by Taku Yoshioka 2005-07-22
% 2005/08/16 Modified O. Yamshita
% 2006/10/3 M. Sato
%  added non-overlapped concatenation mode
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('mode','var'), mode = 0; end;

Nperiod = size(Twindow,1);
Tbegin  = Twindow(:,1);
Tend    = Twindow(:,2);


% Temporal subsampling index
if nargin <2 | isempty(tsubsamp),
	tsubsamp = 1:Tsample;
end

% Subsampling index flag
Nsample = length(tsubsamp);	% # of subsampled data
tflag   = zeros(1,Tsample);	
tflag(tsubsamp) = 1:Nsample;

% Smoothing time window function by sin^2
w_smooth = cell(Nperiod,1);

% First smoothing window
Tperiod = Tend(1)-Tbegin(1)+1; 
w_smooth{1} = ones(1,Tperiod);

%
% Following code is for multiple time windows
%
if Nperiod>=2, 
  if Tend(1)>Tbegin(2), 
    Toverlap = Tend(1)-Tbegin(2)+1;
    w_smooth{1}((Tperiod-Toverlap+1):Tperiod) ...
	= sin((pi/2)*(Toverlap:-1:1)./Toverlap).^2;
  end

  % Middle smoothing window
  for i=2:Nperiod-1
    Tperiod = Tend(i)-Tbegin(i)+1; 
    w_smooth{i} = sin(pi*(1:Tperiod)./Tperiod).^2;
  end

  % Last smoothing window
  Tperiod = Tend(end)-Tbegin(end)+1; 
  w_smooth{end} = ones(1,Tperiod);
  if Tbegin(end)<Tend(end-1), 
    Toverlap = Tend(end-1)-Tbegin(end)+1;
    w_smooth{end}(1:Toverlap) ...
	= sin((pi/2)*(1:Toverlap)/Toverlap).^2; 
  end
end

% Subsampling time index for each time window
Tindex = cell(Nperiod,1);
Nindex = cell(Nperiod,1);

% Time window weighting correction
cnt    = zeros(1,Nsample);

% Normalized time window function
weight = cell(Nperiod,1);

% mode = 1 : non-overlapped concatenation
nid = 0;

% Time window loop
for j=1:Nperiod
  % Subsampling time index
  t1  = Tbegin(j); 	% start time in this period
  t2  = Tend(j); 	% end time   in this period
  tt  = tflag(t1:t2); 	% time index flag in this period
  id  = find( tt > 0 );	% subsampled index
  Nid = tt(id);			% index within 'tsubsamp'
%  Tid = id + t1 -1;	% subsampled time index
  Tid = tsubsamp(Nid);	% subsampled time index
  T   = length(Tid);

  Tindex{j} = Tid;
  
  if mode == 0,
	  Nindex{j} = Nid;
	  weight{j} = w_smooth{j}(id); 
	  cnt(Nid)  = cnt(Nid) + w_smooth{j}(id);
  else
	  n1 = nid + 1;
	  n2 = nid + T;
	  Nindex{j} = n1:n2;
	  weight{j} = ones(1,T);
	  nid = n2;
  end
end;

% Normalization of weighting function
if mode == 0,
	for j=1:Nperiod
	  weight{j} = weight{j}./cnt(Nindex{j});
	end
else
	Nsample = nid;
end

return
%----- END of program -----%

% DEBUG check sum is 1
cnt    = zeros(1,Nsample);

for j=1:Nperiod
  Nid = Nindex{j};
  cnt(Nid)  = cnt(Nid) + weight{j};
end

subplot(2,2,1);
plot(cnt)

subplot(2,2,2);

for j=1:Nperiod
  plot(Nindex{j},weight{j});
  hold on
end

subplot(2,2,3);

for j=1:Nperiod
  plot(Nindex{j},Tindex{j},'.');
  hold on
end
