function [ix_act_ex, jx_act_ex, ix_act, jx_act, Wact, Lact] = ...
          vb_current_area_info(Jinfo,ix_area)
% find selected area index in current file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Lact =Jinfo.Lact ;
ix_act =Jinfo.ix_act ;
Nact = length(ix_act);

if isfield(Jinfo,'ix_act_ex')
	% Z-current
	ix_act_ex = Jinfo.ix_act_ex ;
	Nact_ex = length(ix_act_ex);
	
	if ~isempty(ix_area),
		% Select vertex index 'ix_area' within the active current region
		[jx_act_ex, ix_act_ex] = vb_index2indexsub(ix_area, ix_act_ex);
	else
		jx_act_ex = 1:length(ix_act_ex);
	end
	
	Wact = Jinfo.Wact ;
	Wact = Wact(jx_act_ex,:);

	% active index of Z-current
	jx_act = find( sum(Wact, 1) > 0);
	Wact   = Wact(:,jx_act);
	ix_act = ix_act(jx_act);
	if Lact > 1
		jx_act = repmat(jx_act(:),1,Lact) ...
			   + repmat([0:Lact-1]*Nact,length(jx_act),1);
		jx_act_ex = repmat(jx_act_ex(:),1,Lact) ...
			      + repmat([0:Lact-1]*Nact_ex,length(jx_act_ex),1);
		jx_act = jx_act(:);
		jx_act_ex = jx_act_ex(:);
	end
else
	% J-current
	if ~isempty(ix_area),
		% Select vertex index 'ix_area' within the active current region
		[jx_act, ix_act] = vb_index2indexsub(ix_area, ix_act);
	else
		jx_act = 1:length(ix_act);
	end
	
	if Lact > 1
		jx_act = repmat(jx_act(:),1,Lact) ...
			   + repmat([0:Lact-1]*Nact,length(jx_act),1);
		jx_act = jx_act(:);
	end

	ix_act_ex = ix_act;
	jx_act_ex = jx_act;
	Wact = [];
end
