function	vb_check_variable(B, Cov, Gact, Gall)
% Check variable consistency
%  vb_check_varible(B, Cov, Gact, Gall)
% -- Input
% B{Nsession} : MEG magnetic field data matrix
%                   size(B{i}) = [Nsensors(i), Tsample, Ntrials(i)]
% Gall{Nsession}: Lead field for whole brain region as background activity
%                   size(Gall{i}) = [Nsensors(i) Ndipole]
%                  If Gall = [], the sparse-mode (focal dipoles only) is
%                  executed.
% Gact{Nsession} : Lead field (Current basis function)
%                  for region with high estimation accuracy 
%                   size(Gact{i})  = [Nsensors(i) Ndipole]
%                  If Gact = [], the iso-mode (no focal dipoles) is
%                  executed.
% COV{Nsession}  : Noise covariance matrix
%                   size(COV{i})   = [Nsensors(i) Nsensors(i)]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fprintf('--- Check variable consistency')

Nsession  = length(B);
NsessionA = length(Gact);

if Nsession ~= NsessionA,
	fprintf('\n Number of session in MEG = %d\n', Nsession)
	fprintf(' Number of session in LF  = %d\n', NsessionA)
	error('Number of session is different in MEG and Leadfield')
end

NsessionA = length(Gall);

if Nsession ~= NsessionA,
	fprintf('\n Number of session in MEG = %d\n', Nsession)
	fprintf(' Number of session in LF  = %d\n', NsessionA)
	error('Number of session is different in MEG and Leadfield')
end

for n = 1 : Nsession
	% MEG data
	Nsensor = size(B{n},1);
	
	% Noise covariance
 	[Nsensor1, Nsensor2] = size(Cov{n});
	
	if Nsensor ~= Nsensor1 | Nsensor ~= Nsensor2
		fprintf('\n Number of sensor in MEG = %d\n', Nsensor)
		fprintf(' Number of sensor in Cov = %d, %d\n', Nsensor1, Nsensor2)
		error('Number of sensor is different in MEG and Leadfield')
	end

	% LF for active region
 	[NsensorG, Ndipole] = size(Gact{n});
 	
	if Nsensor ~= NsensorG,
		fprintf('\n Number of sensor in MEG = %d\n', Nsensor)
		fprintf(' Number of sensor in LF  = %d\n', NsensorG)
		error('Number of sensor is different in MEG and Leadfield')
	end
 	
	% LF for background region
 	[NsensorG, Ndipole] = size(Gall{n});
 	
	if Nsensor ~= NsensorG,
		fprintf('\n Number of sensor in MEG = %d\n', Nsensor)
		fprintf(' Number of sensor in LF  = %d\n', NsensorG)
		error('Number of sensor is different in MEG and Leadfield')
	end
end

fprintf(' is OK\n')
