function Twindow = vb_calc_timewindow(Tsample,Tperiod,Tnext)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Time window calculation
if length(Tnext)==1, 
  Nperiod = ceil((Tsample - Tperiod)/Tnext + 1); % Number of periods
  Tbegin = 1:Tnext:((Nperiod-1)*Tnext + 1); % Start time index
  Tend	 = min(Tbegin + Tperiod - 1, Tsample);	% End time index
elseif length(Tnext)~=length(Tperiod), 
  error('Tnext and Tperiod must be the same length.');
else 
  Nperiod = length(Tnext); 
  Tbegin = Tnext;
  Tend = Tbegin+Tperiod-1; 
  if max(Tend)>Tsample, 
    error(['Time window exceeds the length of the MEG' ...
	   ' meassurement.']);
  end
end
Twindow  = [Tbegin' Tend'];
