function GoF = vb_calc_GoF(basis,w,B, mode)
% Calculate GoF (goodness of fit); a measure how magnetic field can be reconstructed by estimated current.
% 
%-- Syntax
% GoF = vb_calc_GoF(basis,w,B)
% GoF = vb_calc_GoF(basis,w,B, mode)
%
%-- Input 
% basis : Lead field (Nch*Nvertex)   
% w     : Estimated current    (Nvertex*Nt)
% B     : MEG observation (Nch*Nt)  
%
%-- Optional
% mode [0] : if mode = 0, Yoshioka-san version
%            if mode = 1, Coefficient of determination, CoD (search 'Coefficient of Determation' in google)
%            CoD is originally defined in ordinal regression problem (over-detremined problem), therefore it may not be appropriate 
%            for sourse localization problem (under-determined problem).
%
% mode = 0,    GoF = 100 * (1 - ((B-B_estimation)^2/B^2))
% mode = 1,    GoF = 100 * (1 - (B-B_estimation)^2/(B-B_bar)^2), where B_bar is mean of B   
%
%-- Output
% GoF : Goodness of Fit for each time point (1*Nt)
%
% 2004-03-12 Taku Yoshioka
% 2005-10-15 O Yamashita
% 2006-05-30 O Yamashita
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 4
    mode = 0;
end

if mode == 0  % default
    tmp1 = sum((basis * w - B).^2,1);
    tmp2 = sum(B.^2,1);
    GoF = 1-tmp1./tmp2;
else
    [Nch, Nt] = size(B);
    Bmean = mean(B,1); %% average over sensor for each time pointr
    ST= sum((B-repmat(Bmean, [Nch, 1])).^2,1); % total variation
    SE= sum((basis * w - B).^2, 1); % error variation

    GoF = 1 - SE./ST;
end

GoF = 100*GoF;
