function vb_area_file_add_dmri_area(area_file, dmri_file, area_key)
% Add parcellation area to the specified area file.
% [Usage]
%    vb_area_file_add_dmri_area(area_file, dmri_file, area_key);
%
% [Input]
%    area_file : area filename(.area.mat)                [string]
%    dmri_file : diffusion mri filename(.dmri.mat)       [string]
%    area_key  : registration key for parcellation area. [string]
%                any name is ok. [default : 'parcellation_area']
%
% [Output]
%    none
%
% [History]
%    2015-02-10 rhayashi
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if nargin <= 1
    error('Please check function usage.');
end

if ~exist('area_key', 'var')
    area_key = 'parcellation_area';
end

if exist(area_file, 'file') ~= 2
    error('Specified area file not found.');
end

if exist(dmri_file, 'file') ~= 2
    error('Specified diffusion mri file not found.');
end

%
% --- Main Procedure
%

% bayes_parm_abs.areafile 
load(dmri_file, 'vbmeg_area_ix');

% add parcellation area to the area file.
area_new.Iextract = vbmeg_area_ix;
area_new.key      = area_key;
vb_add_area(area_file, area_new);
vb_disp('parcellation area was added to areafile.');
