
#include "matrix.h"
#include <math.h> /* Needed for the ceil() prototype */
#include "mex.h"


void mexFunction(
		 int nlhs,       mxArray *plhs[],
		 int nrhs, const mxArray *prhs[]
		 )
{
    /* Declare variable */
    mwSize   m,n,nzmax,nz1,nz2;
    mwIndex  j,j0,k,jpk,*irs,*jcs;
    double   *ip,*jp,*vp,*sr;

	/*  Check for proper number of arguments. */
	if(nrhs!=5) 
	  mexErrMsgTxt("5 inputs required.");
	if(nlhs!=1) 
	  mexErrMsgTxt("One output required.");
	  
	/* sp = make_sparse(I,J,V,M.N) */
	
	/*  Get the number of elements. */
	nzmax = (mwSize) mxGetNumberOfElements(prhs[0]);
	nz1   = (mwSize) mxGetNumberOfElements(prhs[1]);
	nz2   = (mwSize) mxGetNumberOfElements(prhs[2]);

	/*  Check for consistency of arguments. */
	if(nzmax!=nz1) 
	  mexErrMsgTxt("I,J,V should be the same length");
	if(nzmax!=nz2) 
	  mexErrMsgTxt("I,J,V should be the same length");

	/*  Get pointer of input */
	ip = mxGetPr(prhs[0]);
	jp = mxGetPr(prhs[1]);
	vp = mxGetPr(prhs[2]);
	
	/*  Get the number of dim. */
	m = (mwSize) mxGetScalar(prhs[3]);
	n = (mwSize) mxGetScalar(prhs[4]);

    /* Allocate space for sparse matrix */
    plhs[0] = mxCreateSparse(m,n,nzmax,mxREAL);
    
	/*  Get a pointer to sparse matrix */
    sr  = mxGetPr(plhs[0]);
    irs = mxGetIr(plhs[0]);
    jcs = mxGetJc(plhs[0]);

    /* set nonzero elements */
    j0 = 0; jcs[0] = 0;
    for (k=0; (k < nzmax ); k++) {
	  sr[k]  = vp[k];
	  
	  irs[k] = (mwIndex) (ip[k] - 1);
	  jpk = (mwIndex) jp[k];
	  
	  if (jpk > j0){
		  for (j=j0; (j < jpk); j++){
		  	jcs[j] = k;
		  }
		  j0 = jpk;
	  }
    }
    for (j=j0; (j <= n ); j++) {
    	jcs[j] = nzmax;
    }
}

/*
mxSetPr(plhs[0], sr);
mxSetIr(plhs[0], irs);
mxSetJc(plhs[0], jcs);
*/
