function [sp_indx] = get_AtQA_index(Nvact, Ndelta, NL_indx, AtQA)

% Sparse matrix index for each vertex & each delay
sp_indx = cell(Nvact,Ndelta);

% number of elements
%Nindx_nl = zeros(Nvact,Ndelta);
%Nindx_sp = zeros(Nvact,Ndelta);

for nl = 1:Ndelta
	for nv = 1:Nvact
	    if ~isempty(NL_indx{nv,nl})
%    	  AtQA{nl}(NL_indx{nv,nl},NL_indx{nv,nl}) = 1;
	      
	      [J_indx, I_indx] = meshgrid(NL_indx{nv,nl});
	      sp_indx{nv,nl}  = sp_calc_index(I_indx(:), J_indx(:), AtQA{nl});
	      
%	      Nindx_nl(nv,nl) = length(NL_indx{nv,nl});
%	      Nindx_sp(nv,nl) = length(sp_indx{nv,nl});
		end
	end
end

%NLN_indx = sum(sum(Nindx_nl))
%NL2_indx = sum(sum(Nindx_nl.^2))
%Nsp_indx = sum(sum(Nindx_sp))

return
%------------------------- END -----------------------------

Nmem = zeros(Ndelta,1);
for nl = 1:Ndelta
	indx_all = [];
	for nv = 1:Nvact
      indx_all = [indx_all; nl_indx{nv,nl}];
	end
	indx_all = unique(indx_all);
	Nmem(nl) = length(indx_all);
end

AtQA = cell(Ndelta,1);
for nl = 1:Ndelta
  AtQA{nl} = spalloc(Nvact, Nvact, Nmem(nl));
end

%% Initialization
%AtQA = cell(Ndelta,1);
%for nl = 1:Ndelta
%	AtQA{nl} = spalloc(Nvact, Nvact, Nvact);
%end
%
%for nl = 1:Ndelta
%	for nv = 1:Nvact
%    	if ~isempty(nl_indx{nv,nl})
%    		Nz = length(nl_indx{nv,nl});
%      
%    		AtQA{nl}(NL_indx{nv,nl},NL_indx{nv,nl}) = zeros(Nz,Nz);
%    	end
%	end
%end
