function    Vspm = vb_vivid_mm_to_spm_right(V,mode)
% Change Vivid Right-hand mm coordinate to Right-hand SPM (m) coord.
%
% V     : NV x 3 Vivid Right-hand [mm] coordinate
% Vspm  : NV x 3 SPM   Right-hand [m]  coordinate
% mode = 0 : No coordinate transform  & Unit change [mm] -> [m]
% mode = 1 : Vivid -> SPM-R transform & Unit change [mm] -> [m]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- Vivid (mm) coordinate
%   [Right-hand coordinate]
% X: Right  -> Left
% Y: Bottom -> Top
% Z: Back   -> Front

% --- SPM coordinate
%   [Right-hand coordinate]
% X: Left   -> Right
% Y: Back   -> Front
% Z: Bottom -> Top

% written by M. Sato  2005-12-15

if nargin < 2, mode=1; end;

NV   = size(V,1);
Vspm = zeros(NV,3);

switch mode
case    0
    Vspm = V*0.001;
case    1
    Vspm(:,1) = -V(:,1)*0.001;
    Vspm(:,2) =  V(:,3)*0.001;
    Vspm(:,3) =  V(:,2)*0.001;
end
