function	[Fface, Vface] = vb_reduce_face_vertex(facefile, Option)
% reduce MRI-face vertex for plot
%   [Fface, Vface] = vb_reduce_face_vertex(facefile, Option)
% ---- Input file name
% facefile      : MRI face-file          (*.face.mat)
%
% ---- MRI-info in face-file
% surf_face.V = vertex point in face
% surf_face.F = patch index for face
%
% Option.Nmri   = Reduced number of points in MRI face
% --- Output
% Fface = reduced MRI-face surface patch for polot
% Vface = reduced MRI-face surface points for polot
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('Option','var') | ~isfield(Option,'Nmri'), 
	Nmri = 5000;
else
	Nmri = Option.Nmri; 
end;

%
% --- Load MRI face data & landmark(fiducials)
%
load(facefile ,'surf_face');

% Reduce vertex points in reference MRI face
[Fface, Vface] = vb_reducepatch(surf_face.F, surf_face.V, 2 * Nmri);
