function result = vb_msrmnt_store_data( ...
  msrmnt_file, new_data, new_history, new_file)
% store new data
% [usage]
%   result = vb_msrmnt_store_data(msrmnt_file, new_data, new_history, new_file)
% [input]
%   msrmnt_file : <required> <<file>> base file (MEG-MAT or EEG-MAT)
%      new_data : <optional> <<struct>> 
%               :  data group which will be stored []
%               :  all the data size are [Nchannel x Nsample x Ntrial]
%               :   (MEG)
%               :     .bexp
%               :     .bexp_ext
%               :     .refmg
%               :   (EEG)
%               :     .eeg_data
%      new_file : <optional> new file in which the new data will be stored
%               :   [<msrmnt_file>]
%               :  if this is empty, data will be stored to base file
%   new_history : <optional> history data which will be added to
%               :  MEG(EEG)info.History
% [output]
%        result : <<integer>> error code
%               :   0) success
%               :   1) bad msrmnt_file
%               :   2) bad Measurement
% [note]
%
% [history]
%   2008-05-07 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt_file', 'var'), msrmnt_file = ''; end
if ~exist('new_data', 'var'), new_data = []; end
if ~exist('new_history', 'var'), new_history = []; end
if ~exist('new_file', 'var'), new_file = ''; end
[msrmnt_file, new_data, new_history, new_file, result] = ...
  inner_check_arguments(msrmnt_file, new_data, new_history, new_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if result ~= 0
  return;
end

[measurement] = vb_load_device(msrmnt_file);
Measurement = upper(measurement);

old_data = load(msrmnt_file);

info = [];

if ~isempty(new_history)
  info = vb_load_measurement_info(msrmnt_file);
  info = vb_info_add_preprocess_parm(info, new_history);
end

switch Measurement
  case 'MEG'
    % ----- set MEGInfo.History
    if ~isempty(info)
      old_data.MEGinfo = info;
    end

    if isfield(new_data, 'bexp') && ~isempty(new_data.bexp)
      old_data.bexp = new_data.bexp;
    end
    if isfield(new_data, 'bexp_ext') && ~isempty(new_data.bexp_ext)
      old_data.bexp_ext = new_data.bexp_ext;
    end
    if isfield(new_data, 'refmg') && ~isempty(new_data.refmg)
      old_data.refmg = new_data.refmg;
    end
    
  case 'EEG'
    % ----- set EEGInfo.History
    if ~isempty(info)
      old_data.EEGinfo = info;
    end

    if isfield(new_data, 'eeg_data') && ~isempty(new_data.eeg_data)
      old_data.eeg_data = new_data.eeg_data;
    end
    
  otherwise
    fprintf('(%s) unknown MEASUREMENT : %s\n', mfilename, MEASURE);
    result = 2;
    return;
end

% ----- save new file
vb_util_save_struct_fields(new_file, old_data);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [msrmnt_file, new_data, new_history, new_file, result] = ...
  inner_check_arguments(msrmnt_file, new_data, new_history, new_file)
func_ = mfilename;
result = 0; % success

if isempty(msrmnt_file)
  fprintf('(%s)msrmnt_file is a required parameter\n', func_);
  result = 1;
  return;
end

if exist(msrmnt_file, 'file') ~= 2
  fprintf('(%s)cannot find msrmnt_file : %s\n', func_, msrmnt_file);
  result = 1;
  return;
end

if isempty(new_file)
  new_file = msrmnt_file;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
