function [result] = vb_msrmnt_make_preprocessed_file( ...
  org_file, update_spec, new_file)
% make new MEG-MAT or EEG-MAT file which have preprocessed data
%
% [usage]
%   [result] = vb_msrmnt_make_preprocessed_file( ...
%                org_file, update_spec, new_file)
%
% [input]
%      org_file : <required> <<file>> base MEG-MAT or EEG-MAT file
%   update_spec : <required> <<struct>> update information
%               :   .preprocess_parm : <required> parameters to preprocess
%               :                    :  this will be saved as a history
%               :   .active_channel  : <optional> active channel list
%               :   .active_trial    : <optional> active trial list
%      new_file : <optional> new MEG-MAT or EEG-MAT file
%               :  if this is empty, org_file will be overwritten
%
% [output]
%        result :     0) success
%               : not 0) failure
%               :
% [note]
%   this function does not check validity of update_spec
%
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('org_file', 'var'), org_file = ''; end
if ~exist('update_spec', 'var'), update_spec = []; end
if ~exist('new_file', 'var'), new_file = ''; end
[org_file, update_spec, new_file, result] = ...
  inner_check_arguments(org_file, update_spec, new_file);
if result ~= 0, return; end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

[info, info_type] = vb_load_measurement_info(org_file);

if isfield(update_spec, 'active_channel')
  [info, result] = vb_info_set_active_channel(info, ...
    update_spec.active_channel);
  if result ~= 0
    fprintf('(%s, error code:%d)fail to info_set_active_channel\n', ...
      mfilename, result);
    return;
  end
end

if isfield(update_spec, 'active_trial')
  [info, result] = vb_info_set_active_trial(info, ...
    update_spec.active_trial);
  if result ~= 0
    fprintf('(%s, error code:%d)fail to info_set_active_trial\n', ...
      mfilename, result);
    return;
  end
end

info = vb_info_add_preprocess_parm(info, update_spec.preprocess_parm);

% --- save new EEG-MAT file
org_msrmnt = load(org_file);
if strcmp(info_type, 'MEGINFO')
  org_msrmnt.MEGinfo = info;
elseif strcmp(info_type, 'EEGINFO')
  org_msrmnt.EEGinfo = info;
else
  % ignore
end
vb_util_save_struct_fields(new_file, org_msrmnt);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [org_file, update_spec, new_file, err_code] = ...
  inner_check_arguments(org_file, update_spec, new_file)
func_ = mfilename;
err_code = 0;
if isempty(org_file)
  fprintf('(%s)org_file is a required parameter', func_);
  err_code = bitor(err_code, 1);
end

if isempty(update_spec)
  fprintf('(%s)update_spec is a required parameter', func_);
  err_code = bitor(err_code, 2);
end

if ~isempty(org_file) && exist(org_file, 'file') ~= 2
  fprintf('(%s)cannot find org_file: %s\n', func_, org_file);
  err_code = bitor(err_code, 4);
end

if ~isempty(update_spec) && ~isfield(update_spec, 'preprocess_parm')
  fprintf('(%s)preprocess_parm is a required field of update_spec\n', func_);
  err_code = bitor(err_code, 8);
end

if err_code ~= 0
  % not be necessary to continue
  return;
end

if isempty(new_file)
  new_file = org_file;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
