function Measurement = vb_info_get_measurement(info)
% get measurement from info struct
% [usage]
%   Measurement = vb_info_get_measurement(info)
% [input]
%          info : <required> <<struct>> 
%               :   stuct of information (EEGinfo or MEGinfo or other)
% [output]
%   Measurement : measurement information
%               : 'MEG' or 'EEG'. other is unexpected
% [note]
%   acceptable info : MEGinfo, EEGinfo
% [history]
%   2006-12-21 (Sako) initial version
%   2008-04-11 (Sako) modified variable name 'measurement' -> 'Measurement'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(info, 'Measurement')
  Measurement = 'MEG';
  return;
else
  Measurement = info.Measurement;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
  return;
end
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
