function [ch_label] = vb_info_get_channel_label(info, active_swt)
% return channel label from MEGinfo or EEGinfo
% [usage]
%   [ch_label] = vb_info_get_channel_label(info, active_swt)
% [input]
%   info : <required> <<struct>> MEGinfo or EEGinfo
%   active_swt : <optional> <<boolean>> [false]
%              :    true) return only active channels
%              :   false) return all the channels
% [output]
%   ch_label : channel label
%            :  (MEG) --> only meg channel not extra nor reference
%            :  (EEG) --> only eeg channel not extra
% [note]
%   @see vb_meginfo_get_channel_label_meg
%   @see vb_eeginfo_get_channel_label
% [history]
%   2008-04-14 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[info, active_swt, Measurement] = inner_check_arguments(info, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
switch Measurement
  case 'MEG'
    ch_label = vb_meginfo_get_channel_label_meg(info, active_swt);
  case 'EEG'
    ch_label = vb_eeginfo_get_channel_label(info, active_swt);
  otherwise
    fprintf('(%s)unexpected Measurement : %s\n', mfilename, Measurement);
    ch_label = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_swt, Measurement] = ...
  inner_check_arguments(info, active_swt)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

Measurement = vb_info_get_measurement(info);

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %


%%% END OF FILE %%%
