function	vb_merge_multi_file_trial(fname, fout, cond_label)
% Merge trials of multiple files
% --- Usage
%    vb_merge_multi_file_trial(fname, fout)
%    vb_merge_multi_file_trial(fname, fout, cond_label)
% --- Input
%  fname : set of file name of trial onset [cell string]
%  fname{i} : i-th trial onset file name   [ i=1:Nfile ]
%  fout   : output file name of merged trials
% --- Optional Input
%  cond_label(i) : condition label for fname{n} [ i=1:Nfile ]
% --- Save variables
% status : status signal
% status_val(m) = status value for m-th condition (m=1:Ncomdition)
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : condition label for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
% parm : parameter setting
%  parm.fsamp : Sample Frequency [Hz]
%  parm.Pretrigger_ms : Pretrigger period   [msec]
%  parm.Posttrigger_ms: Posttrigger period  [msec]
%
% 2009-6-14  Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~iscell(fname), error('argument should be cell string');end

Nfile = length(fname);
if nargin < 3, cond_label = [1:Nfile]; end;

load(fname{1},'ix_trial','trig','status','status_val','parm');

fs = parm.fsamp;
Tmax = size(status,2);
[T, Ntr] = size(ix_trial);

Ix_trial = ix_trial;
Trig     = trig    ;
Cond_id  = repmat(cond_label(1), 1, Ntr);
Status_val = status_val;
Condition  = parm.condition;

% load trial 
for n = 2:Nfile
	load(fname{n},'ix_trial','trig','status','status_val','parm');
	
	if fs ~= parm.fsamp, error('Sample frequency mismatch'); end;
	if Tmax ~= size(status,2), error('Sample length mismatch'); end
	if T ~= size(ix_trial,1), error('Trial length mismatch'); end

	Ix_trial = [Ix_trial, ix_trial];
	Trig     = [Trig    , trig    ];
	Cond_id  = [Cond_id , repmat(cond_label(n), 1, length(trig))];
	Status_val = [Status_val, status_val];
	Condition  = cat(2,Condition,  parm.condition);
end

trig     = Trig    ;
ix_trial = Ix_trial;
cond_id  = Cond_id ;

% sort time order
[trig, ix] = sort(trig);
ix_trial = ix_trial(:,ix);
cond_id  = cond_id(ix) ;

status_val     = Status_val;
parm.condition = Condition ;

fprintf('# of merge trials = %d\n',length(trig));

vb_fsave(fout,'ix_trial','trig','cond_id','status','status_val','parm');
