function	[ix_trial,trig,cond_id,status_val,status_out] = ...
			vb_get_time_index_from_onset(trig,parm)
% get trial time index from status channel
%
%    [ix_trial,trig,cond_id,status_val,status_out] = ...
%          vb_get_time_index_from_onset(trig,parm)
% --- Inout
%  trig(n)       : Onset time index for n-th trial 
%  parm.Pretrigger_ms : Pretrigger period   [msec]
%  parm.Posttrigger_ms: Posttrigger period  [msec]
%  parm.status_level : status level (ratio for max) for onset [Ncondition x 1]
%  parm.fsamp     : Sample Frequency [Hz]
% --- Output
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : Condition ID for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
% status_val(m) = parm.status_level(m) * max(status)
% status_out : masked status signal if mask flag is specified
%
% 2009-6-11 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Pre/Post period in msec
Pretrigger_ms  = parm.Pretrigger_ms ; % [msec]
Posttrigger_ms = parm.Posttrigger_ms; % [msec]

% Sample Frequency [Hz]
fsamp  = parm.fsamp;
%fprintf('Sampleing Frequency: %6.1f [Hz]\n',fsamp)

% Sample number for Pre/Post period
Pretrigger  = ceil(Pretrigger_ms *(fsamp/1000));
Posttrigger = ceil(Posttrigger_ms*(fsamp/1000));

status_level  = parm.status_level ;
status_val = status_level;
status_out = status_level;

Ntrial = length(trig);
cond_id = ones(Ntrial,1);

% trig(n) : n-th triger time
% cond_id(n) : corresponding condition label

%--- sort triger timing according to temporal order
[trig, jx] = sort(trig);

% Time index for one trial
ix = (-Pretrigger:Posttrigger)';
Tp = length(ix);

% Time index for all trials extracted from 'trig'
trig = round(trig);
ix_trial = repmat(ix,[1 Ntrial]) + repmat(trig,[Tp 1]);

