function	y = vb_get_status_mask(x, mask_bit, status_offset)
% get status value by masking irrelevant bit
%  y = vb_get_status_mask(x)
%  y = vb_get_status_mask(x, mask_bit)
%  y = vb_get_status_mask(x, mask_bit, status_offset)
% --- Input
%  x : status signal (1 x T or T x 1)
%  status_offset : shift value for status
%    x = x - status_offset
%  mask_bit : binary bit mask pattern [STRING]
%   Ex.  '1100' 
% Matlab binary expression
% Left-> higher bit Right-> lower bit
%  12 =   1100
%  20 =  10100
%  28 =  11100
%  36 = 100100
% 
% 2009-6-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% dec2bin(d) ϡd2ʿɽʸȤƽ
% bin2dec(binarystr)ϡХʥʸ10ʿȤƽ
% C=bitand(A,B)ϡ2ĤABΥӥåñ̤

% value for NIRS-EEG online BCI
%
%Trigger.Task1       = 12;    %  00110000  NIRS=1 
%Trigger.Task2       = 20;    %  00101000  NIRS=2
%Trigger.Task3       = 28;    %  00111000  NIRS=3
%Trigger.Task4       = 36;    %  00100100  NIRS=4


% Offset
if nargin < 3 || isempty(status_offset)
	status_offset = 0;
end

% Mask Bit
if nargin < 2 || isempty(mask_bit)
	mask_bit = '';
end

y = x - status_offset;
if ~isempty(mask_bit)
    mask_val = bin2dec(mask_bit);
    y = bitand(y, mask_val);
end

return

%y = zeros(size(x));
%
%for n=1:length(x)
%	y(n) = bitand(x(n),mask_val);
%end
