function [meg_info] = vb_ykgwfile_load_header(ykgwfile, meg_info)
% load header information from yokogawa file and update meg_info
%
% [usage]
%   [meg_info] = vb_ykgwfile_load_header(ykgwfile, meg_info)
%
% [input]
%   ykgwfile : <required> <<file>> yokogawa data file path
%   meg_info : <optional> <<struct>> MEG information which is updated
%            :  if this is not specified or is empty, meg_info will be created
%            :  newly.
%
% [output]
%   meg_info : <<struct>> updated meg_info structure
%
% [note]
%   See also
%     vb_ykgwfile_load_acq_cond
%
% [history]
%   2007-06-12 (Sako) initial version
%   2008-03-12 (Sako) renewed according to the new specification
%   2011-05-26 (Sako) modified according to the new data format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ykgwfile', 'var'), ykgwfile = []; end
if ~exist('meg_info', 'var'), meg_info = []; end
[ykgwfile, meg_info, meg_id] = inner_check_arguments(ykgwfile, meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
%
% -- Data acquisition information
%
define = vb_define_coordinate;

acq_cond = vb_ykgwfile_load_acq_cond(ykgwfile);

% MEG
meg_info.MEG_ID      = meg_id;
meg_info.device      = 'YOKOGAWA';
meg_info.coord_type  = define.COORDINATE_YOKOGAWA_RIGHT_M;

% --- MEGinfo.acq_type
meg_info = vb_meginfo_set_acqtype(meg_info, acq_cond);

% --- update MEGinfo.acq_info
meg_info = vb_meginfo_set_acqcond(meg_info, acq_cond);

meg_info.Nsample     = acq_cond.frame_length;
meg_info = vb_meginfo_set_pre_trigger(meg_info, acq_cond.pretrigger_length);
meg_info.SampleFreq  = acq_cond.sample_rate;
meg_info.Nrepeat     = acq_cond.num_epoch;

Trial = [];
for i_trial = 1:meg_info.Nrepeat
  Trial(i_trial).number = i_trial;
  Trial(i_trial).sample = 1:meg_info.Nsample;
end
meg_info.Trial = Trial';
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ykgwfile, meg_info, meg_id] = ...
  inner_check_arguments(ykgwfile, meg_info)

func_ = mfilename;
if isempty(ykgwfile)
  error('(%s) ykgwfile is a required parameter', func_);
end

% check validity as a file
if exist(ykgwfile, 'file') ~= 2
  error('(%s) cannot find yokogawa file : %s', func_, ykgwfile);
end

if isempty(meg_info)
%   error('(%s) meg_info is a required parameter', func_);
end

% get MEG_ID
[path, meg_id] = fileparts(ykgwfile);

return;
%
% --- end of inner_check_arguments()
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- END OF FILE --- %
