function [meg_info] = vb_ykgwfile_load_data(ykgwfile, meg_info, out_base)
% load measurement data, which is calibrated, from yokogawa file and store
%  the loaded data by binary format.
%
% [usage]
%   [meg_info] = vb_ykgwfile_load_data(ykgwfile, meg_info, out_base)
%
% [input]
%   ykgwfile : <required> <<file>> yokogawa file path
%   meg_info : <required> <<struct>> MEG information
%   out_base : <required> base directory of data directory
%            :            normally, it is the path of new MEG-MAT file.
%
% [output]
%   meg_info : <<struct>> which may be updated by adding bin_dir field
%
% [note]
%   See also
%     vb_meg_yokogawa_store_bin
%
% [history]
%   2007-07-03 (Sako) initial version
%   2011-02-17 (Sako) added new arguement 'out_base' and delete returned data
%   2011-06-22 (Sako) modified to fit the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ykgwfile', 'var'), ykgwfile = []; end
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('out_base', 'var'), out_base = ''; end
[meg_info, out_base, save_swt] = ...
  inner_check_arguments(ykgwfile, meg_info, out_base);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if save_swt == true
  vb_meg_yokogawa_store_bin(ykgwfile, meg_info, out_base);
else
  warning('(%s) save_swt is false. Please check your saveman\n', mfilename);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, out_base, save_swt] = ...
  inner_check_arguments(ykgwfile, meg_info, out_base)

func_ = mfilename;

if isempty(ykgwfile)
  error('(%s) ykgwfile is a required parameter', func_);
end

if isempty(meg_info)
  error('(%s) meg_info is a required parameter', func_);
end

if isempty(out_base)
  error('(%s) out_base is a required parameter', func_);
end

% check validity as a file
if exist(ykgwfile, 'file') ~= 2
  error('(%s) cannot find yokogawa file : %s', func_, ykgwfile);
end

if isfield(meg_info, 'saveman')
  save_swt = vb_saveman_get_switch(meg_info.saveman);
else
  save_swt = false;
end

return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
