function [acq_cond] = vb_ykgwfile_load_acq_cond(ykgwfile)
% load data acquisition condition from yokogawa file
%
% [usage]
%   [acq_cond] = vb_ykgwfile_load_acq_cond(ykgwfile)
%
% [input]
%   ykgwfile : <required> <<file>> yokogawa file
%
% [output]
%   acq_cond : <<struct>> acquisition condition 
%            :  (Continuous, Evoked, sampling rate, trigger settings, etc)
%
% [note]
% 
% [history]
%   2011-04-15 (Sako) replaced old function with this
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
[ykgwfile] = inner_check_arguments(ykgwfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
acq_cond_org = getYkgwHdrAcqCond(ykgwfile);
vb_define_device;

% AcqTypeContinuousRaw = 1;
% AcqTypeEvokedAve     = 2;
% AcqTypeEvokedRaw     = 3;

switch acq_cond_org.acq_type
  case AcqTypeContinuousRaw
    % extra return values are as follows.
    %  .sample_rate  : Sampling rate [Hz]
    %  .sample_count : The number of samples which were actually acquired
    acq_cond = ...
      struct('type'                , 'Continuous_Raw', ...
             'type_code'           , acq_cond_org.acq_type, ...
             'sample_rate'         , acq_cond_org.sample_rate, ...
             'frame_length'        , acq_cond_org.sample_count, ...
             'pretrigger_length'   , [], ...
             'num_epoch'           , 1 , ...
             'setup_sample_count'  , [], ...
             'trigger_mode'        , [], ...
             'trigger_setting'     , [] );
    
  case AcqTypeEvokedAve
    % extra return values are as follows.
    %  .sample_rate
    %  .frame_length
    %  .pretrigger_length
    %  .average_count
    acq_cond = ...
      struct('type'                  , 'Evoked_Ave', ...
             'type_code'             , acq_cond_org.acq_type, ...
             'sample_rate'           , acq_cond_org.sample_rate, ...
             'frame_length'          , acq_cond_org.frame_length, ...
             'pretrigger_length'     , acq_cond_org.pretrigger_length, ...
             'setup_average_count'   , [], ...
             'actual_average_count'  , acq_cond_org.average_count, ...
             'num_epoch'             , 1, ...
             'rejected_average_count', [], ...
             'trigger_mode'          , [], ...
             'trigger_setting'       , [], ...
             'multi_trigger_count'   , [], ...
             'multi_trigger_list'    , [] );
    
  case AcqTypeEvokedRaw
    % extra return values are as follows.
    %  .sample_rate
    %  .frame_length
    %  .pretrigger_length
    %  .average_count
    acq_cond = ...
      struct('type'                  , 'Evoked_Raw', ...
             'type_code'             , acq_cond_org.acq_type, ...
             'sample_rate'           , acq_cond_org.sample_rate, ...
             'frame_length'          , acq_cond_org.frame_length, ...
             'pretrigger_length'     , acq_cond_org.pretrigger_length, ...
             'setup_measure_count'   , [], ...
             'num_epoch'             , acq_cond_org.average_count, ...
             'rejected_measure_count', [], ...
             'trigger_mode'          , [], ...
             'trigger_setting'       , [], ...
             'multi_trigger_count'   , [], ...
             'multi_trigger_list'    , [] );
           
  otherwise
    warning('(%s) invalid acq_type : %d\n', mfilename, acq_cond_org.acq_type);
    acq_cond = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ykgwfile] = inner_check_arguments(ykgwfile)
func_ = mfilename;
if isempty(ykgwfile)
  error('(%s) ykgwfile is a required parameter', func_);
end

if exist(ykgwfile, 'file') ~= 2
  error('(%s) cannot find ykgwfile : %s', func_, ykgwfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF File --- %
