function [data] = vb_meg_yokogawa_store_bin(ykgwfile, ...
  meg_info, out_base, verbose_swt)
% load data from yokogawa file, and store the loaded data in binary format
%
% [usage]
%   [data] = vb_meg_yokogawa_store_bin(ykgwfile, ...
%              meg_info, out_base, verbose_swt)
%
% [input]
%      ykgwfile : <required> yokogawa file
%      meg_info : <required> <<struct>> meg information
%      out_base : <required> base directory of data directory
%               :            normally, it is the path of new MEG-MAT file.
%   verbose_swt : <optional> switch to output verbose message [true]
%
% [output]
%        data : acquired data [n_channel x n_sample x n_trial]
%
% [note]
%   See also
%     vb_meg_yokogawa_store_bin_channel
%
% [history]
%   2007-06-12 (Sako) initial version
%   2007-08-22 (Sako) changed stored directory specification
%   2009-06-23 (Sako) changed to store data of 'Evoked_Raw' by channel
%   2011-02-17 (Sako) added new argument 'out_base'
%   2011-06-22 (Sako) modified to fit the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
% if ~exist('fid', 'var'), fid = []; end
if ~exist('ykgwfile', 'var'), ykgwfile = ''; end
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('out_base', 'var'), out_base = ''; end
if ~exist('verbose_swt', 'var'), verbose_swt = []; end

[ykgwfile, meg_info, out_base, VERBOSE] = ...
  inner_check_arguments(ykgwfile, meg_info, out_base, verbose_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
[data] = ...
  vb_meg_yokogawa_store_bin_channel(ykgwfile, meg_info, out_base, verbose_swt);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ykgwfile, meg_info, out_base, verbose_swt] = ...
  inner_check_arguments(ykgwfile, meg_info, out_base, verbose_swt)

func_ = mfilename;

if isempty(ykgwfile)
  error('(%s) ykgwfile is a required parameter', func_);
end

if isempty(meg_info)
  error('(%s) meg_info is a required parameter', func_);
end

if isempty(out_base)
  error('(%s) out_base is a required parameter', func_);
end

if isempty(vb_meginfo_get_acqtype(meg_info))
  error('(%s) MEGinfo does not have ''acq_type'' field', func_);
end

if isempty(verbose_swt)
  verbose_swt = true;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
