function [calib_info] = vb_calibinfo_set_sensor_label(calib_info, label)
% set sensor label to calibinfo struct
%
% [usage]
%   [calib_info] = vb_calibinfo_set_sensor_label(calib_info, label)
%
% [input]
%   calib_info : <optional> <<struct>> MEGinfo.calib_info
%              :  This field is not a standard field of MEGinfo.
%              :  This is used only when importing data
%        label : <optional> {n_ch x 1}
%              :  If this is not specified or empty, default labels will be 
%              :  applied. {'0', '1', '2', ... '(n_ch-1)'}
%
% [output]
%   calib_info : updated one
%
% [note]
%
% [history]
%   2011-07-04 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('calib_info', 'var'), calib_info = []; end
if ~exist('label', 'var'), label = []; end
[calib_info, label] = inner_check_arguments(calib_info, label);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
calib_info.sensor_label = label;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [calib_info, label] = inner_check_arguments(calib_info, label)
func_ = mfilename;
if isempty(calib_info)
  % sensor_label will be added
%   error('(%s) calib_info is a required parameter', func_);
end

if isempty(label)
  n_ch = length(calib_info.sensitivity);
  label = 0:(n_ch-1);
end
if size(label, 1) == 1
  % transpose to [n_ch x 1]
  label = label';
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
