function [len] = vb_calibinfo_get_data_bit_len(calib_info)
% return length of data bit from calib_info
%
% [usage]
%   [len] = vb_calibinfo_get_data_bit_len(calib_info)
%
% [input]
%   calib_info : <required> <<struct>> calibration information
%              :  temporary struct for pre-process
%              :   (new format 2011)
%              :   .sensitivity <<struct array>> [1 x n_ch]
%              :     .offset
%              :     .gain
%              :   .fll <struct array>> [1 x n_fll]
%              :     .gain
%              :   .ad
%              :     .bit
%              :     .analog_range
%              :
%              :   .sensor_label {n_ch x 1}
%
% [output]
%          len : length of data bit (normally 16)
%
% [note]
% 
% [history]
%   2011-07-20 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('calib_info', 'var'), calib_info = []; end
[calib_info] = inner_check_arguments(calib_info);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
len = calib_info.ad.bit;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [calib_info] = inner_check_arguments(calib_info)
func_ = mfilename;
if isempty(calib_info)
  error('(%s) calib_info is a required parameter', func_);
end

if ~isfield(calib_info, 'ad')
  error('(%s) ad (analog/digital) is a required field', func_);
end

if ~isfield(calib_info.ad, 'bit')
  error('(%s) ad.bit is a required field', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
