function [meginfo] = vb_meginfo_set_sample_number(meginfo, n_sample)
% <<setter>> number of sample of MEGinfo
% [usage]
%   [meginfo] = vb_meginfo_set_sample_number(info, n_sample)
% [input]
%    meginfo : <required> <<struct>> MEGinfo
%   n_sample : <optional> sample number [0]
% [output]
%    meginfo : MEGinfo after updating
% [note]
%
% [history]
%   2008-02-21 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('n_sample', 'var'), n_sample = []; end
[meginfo, n_sample] = inner_check_arguments(meginfo, n_sample);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo.Nsample = n_sample;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, n_sample] = inner_check_arguments(meginfo, n_sample)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(n_sample)
  n_sample = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
