function [result] = vb_meginfo_sensor_weight_refmg_exist(meg_info)
% confirm whether meg_info has sensor_weight_ref field field or not
% [usage]
%   [result] = vb_meginfo_sensor_weight_refmg_exist(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo
% [output]
%     result : <<boolean>> 
%            :  true ) meg_info has the 'sensor_weight_ref' field
%            :  flase) meg_info does not have the 'sensor_weight_ref' field
% [note]
%   The field is "MEGinfo.device_info.sensor_weight_ref".
% [history]
%   2011-07-20 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- Check point is only whether there is the field.

% --- old format
if isfield(meg_info, 'sensor_weight_ref')
  warning('(%s) "MEGinfo.sensor_weight_ref" is old format\n', mfilename);
  result = true;
  return;
end

result = false;
if ~isfield(meg_info, 'device_info'), return; end
if ~isfield(meg_info.device_info, 'sensor_weight_ref'), return; end
if isempty(meg_info.device_info.sensor_weight_ref), return; end

result = true;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s) meg_info is a required parameter', func_);
end
return;
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
