function [bit_len] = vb_meginfo_get_valid_data_bit_len(meg_info, init_swt)
% return valid data bit length by following the priority rule
%
% [usage]
%   [bit_len] = vb_meginfo_get_valid_data_bit_len(meg_info, init_swt)
%
% [input]
%   meg_info : <required> <<struct>> MEG header information
%   init_swt : <optional> initialize switch true or [false]
%            :  if this is true, force into reloading
%
% [output]
%    bit_len : data bit length
%
% [note]
%   (priority rule) : data_bit_len field > from data_file > default
%   <default> value is 12 for now because old MEGinfo may not have necessary
%   fields which are in order to determine value.
%   This is used getYkgwHdrCalib function internally.
%
%   See also
%     vb_meginfo_load_data_bit_len
%     getYkgwHdrCalib
%
% [history]
%   2007-06-12 (Sako) initial version
%   2010-02-04 (Sako) reformatted if statement to erace warnings
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('init_swt', 'var'), init_swt = []; end
[meg_info, init_swt] = inner_check_arguments(meg_info, init_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% --- FORCE INTO RELOADING
if init_swt
  bit_len = vb_meginfo_load_data_bit_len(meg_info);
  if ~isempty(bit_len)
    return;
  end
end

% --- CONSTANTS
DEFAULT_BIT_LEN = 12;

% --- PRIORITY #1
bit_len = vb_meginfo_get_data_bit_len(meg_info);
if ~isempty(bit_len)
  return;
end

% --- PRIORITY #2
bit_len = vb_meginfo_load_data_bit_len(meg_info);
if ~isempty(bit_len)
  return;
end

% --- PRIORITY #3
bit_len = DEFAULT_BIT_LEN;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, init_swt] = inner_check_arguments(meg_info, init_swt)

func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end

if isempty(init_swt)
  init_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILES --- %
