function [s_weight] = vb_meginfo_get_sensor_weight_refmg(meg_info)
% MEGinfo getter for sensor weight
% [usage]
%   [s_weight] = vb_meginfo_get_sensor_weight_refmg(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo
% [output]
%   s_weight : value of sensor weight of reference channel [n_ch_ref x 1]
% [note]
%   if the given MEGinfo does not have an appropriate field, return empty
%   (new format) MEGinfo.device_info.sensor_weight_ref
% [history]
%   2007-07-12 (Sako) initial version
%   2011-07-20 (Sako) modified according to the new format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
s_weight = [];

% --- old format
if isfield(meg_info, 'sensor_weight_ref')
  warning('(%s) "MEGinfo.sensor_weight_rf" is old format\n', mfilename);
  s_weight = meg_info.sensor_weight_ref;
end

if ~isfield(meg_info, 'device_info'), return; end
if ~isfield(meg_info.device_info, 'sensor_weight_ref'), return; end
s_weight = meg_info.device_info.sensor_weight_ref;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;

if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
