function [weight] = vb_meginfo_get_sensor_weight_meg(meginfo)
% MEGinfo getter for sensor weight
% [usage]
%   [weight] = vb_meginfo_get_sensor_weight_meg(meginfo)
% [input]
%   meginfo : <required> <<struct>> MEG information
% [output]
%    weight : value of sensor weight of MEG
% [note]
%   if the given MEGinfo does not have an appropriate field, return empty
% [history]
%   2007-07-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
weight = meginfo.sensor_weight;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo] = inner_check_arguments(meginfo)

func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'sensor_weight')
  meginfo.sensor_weight = [];
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
