function Nsample = vb_meginfo_get_sample_number(meginfo)
% get number of sample from MEGinfo struct and return it
% [usage]
%   Nsample = vb_meginfo_get_sample_number(meginfo)
% [input]
%   meginfo : <required> <<struct>> MEG information
% [output]
%   Nsample : number of sample
% [note]
%   
% [history]
%   2007-05-25 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Nsample = meginfo.Nsample;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo] = inner_check_arguments(meginfo)
func_ = 'vb_meginfo_get_sample_number';
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'Nsample')
  error('(%s)Nsample is a required field of MEGinfo', func_);
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
