function  eeginfo = vb_meginfo_filter_EEGinfo(meginfo, ch_list)
% leave channel label list in MEGinfo.EEGinfo according as ch_list
%
% [usage]
%   eeginfo = vb_meginfo_filter_EEGinfo(meginfo, ch_list)
%
% [input]
%   meginfo : <required> <<struct>> MEG header information
%   ch_list : <required> valid channel label list
%
% [output]
%   eeginfo : <<struct>> MEGinfo.EEGinfo whose fields are as follows
%            :   there are two types *_name (label name) and *_ix (index)
%            :   .all_ch       : all channel
%            :   .eeg_ch       : eeg channel
%            :   .null_ch      : null channel
%            :   .etc_ch       : etc channel
%            :   .trigger_ch   : trigger channel
%            :   .ecg_ch       : ecg channel
%            :   .refmg_ch     : refference magnetometer
%           :  sizes of these fields are [N x 1]
%
% [note]
%   if there is not appropriate label, the channel will be removed
%
% [history]
%   2007-07-13 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var') meginfo = []; end
if ~exist('ch_list', 'var') ch_list = []; end
[meginfo, ch_list] = inner_check_arguments(meginfo, ch_list);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo = meginfo.EEGinfo;

if isempty(meginfo.EEGinfo) || isempty(ch_list)
  return;
end

field_ch_name = { ...
    'eeg_ch_name', ...
    'null_ch_name', ...
    'etc_ch_name', ...
    'trigger_ch_name', ...
    'ecg_ch_name', ...
    'refmg_ch_name' ...
};

field_ch_idx = { ...
    'eeg_ch_ix', ...
    'null_ch_ix', ...
    'etc_ch_ix', ...
    'trigger_ch_ix', ...
    'ecg_ch_ix', ...
    'refmg_ch_ix' ...
};

%
% --- get channel type & make eeg data
%
start_pos = 1;

all_name = [];

for field_cnt = 1:length(field_ch_name)
  cur_field = field_ch_name{field_cnt};
  cur_ix_field = field_ch_idx{field_cnt};
  
  if isfield(eeginfo, cur_field)
    [res,idx] = vb_util_check_numerical_lists(eeginfo.(cur_field), ch_list);
    if ~isempty(idx)
      eeginfo.(cur_field) = eeginfo.(cur_field)(idx,:);
      all_name = [all_name;eeginfo.(cur_field)];

      end_pos = start_pos + length(idx) - 1;
      eeginfo.(cur_ix_field) = [start_pos:end_pos]';
      
      start_pos = start_pos + length(idx);
    else
      eeginfo = rmfield(eeginfo, cur_field);
      eeginfo = rmfield(eeginfo, cur_ix_field);
    end
  end
end

eeginfo.all_ch_name = all_name;
eeginfo.all_ch_ix = [1:start_pos-1]';

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, ch_list] = inner_check_arguments(meginfo, ch_list)
func_ = mfilename;

if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if ~isfield(meginfo, 'EEGinfo')
  meginfo.EEGinfo = [];
end

if isempty(ch_list)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
