function vb_megfile_make_loaded_megfile(megfile, ...
  ch_list, loaddata, newfile, overswt, coord_type)
% make MEG-MAT file which includes loaded data and updated information
%
% [usage]
%   vb_megfile_make_loaded_megfile(megfile, ...
%     ch_list, loaddata, newfile, overswt, coord_type)
%
% [input]
%    megfile : <required> <<file>> MEG-MAT file before loading
%    ch_list : <required> <<struct>> channel label list of loaded data
%   loaddata : <required> loaded data
%            :  [Nchannel x Nsample x Ntrial]
%    newfile : <required> <<file>> new MEG-MAT file name
%    overswt : <optional> switch whether overwrite or not if newfile exists
%            :  [true] : overwrite
%            :   false : does not overwrite
% coord_type : <optional> <<string>> coordinate type ['']
%
% [output]
%   none
%
% [note]
%   If length of channel and channel number of loaded data are different,
%   this function aborts running.
%
% [history]
%   2007-07-12 (Sako) initial version
%   2011-07-20 (Sako) modified how to set sensor_weight_ref
%   2011-07-29 (Sako) the function to get sensor position was replaced
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
if ~exist('ch_list', 'var'), ch_list = []; end
if ~exist('loaddata', 'var'), loaddata = []; end
if ~exist('newfile', 'var'), newfile = []; end
if ~exist('overswt', 'var'), overswt = []; end
if ~exist('coord_type', 'var'), coord_type = ''; end
[megfile, ch_list, loaddata, newfile, overswt, coord_type] = ...
  inner_check_arguments(megfile, ...
    ch_list, loaddata, newfile, overswt, coord_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;
error('(%s) !!!SORRY THIS FUNCTION PROHIBITED!!!', func_);

bexp              = [];
eeg               = [];
refmg             = [];

MEGinfo           = [];

ExtraChannelInfo  = [];
saveman           = [];

Nchannel_all = size(loaddata,1);
Nsample      = size(loaddata,2);
Ntrial       = size(loaddata,3);

[meginfo] = vb_megfile_load_meginfo(megfile);
[swm] = vb_meginfo_get_sensor_weight_meg(meginfo);
[swr] = vb_meginfo_get_sensor_weight_refmg(meginfo);
[p,qp] = vb_load_sensor(megfile, 'MEG');
[ref_p,ref_qp] = vb_load_sensor(megfile, 'REF');

[ch_info] = vb_megfile_get_applicable_channel(megfile, ch_list);

% --- MEG CHANNEL
meg_ch = vb_ch_info_get_channel_list_meg(ch_info);
if ~isempty(meg_ch)
  % position
  org_meg_ch = vb_meginfo_get_channel_label_meg(meginfo);

  [res, idx] = vb_util_is_included_list(org_meg_ch, meg_ch);
  pick = p(idx,:);
  Qpick = qp(idx,:);
  if ~isempty(swm)
    sensor_weight = swm(idx,:);
  end
  Nchannel_meg = length(meg_ch,1);
%   MEGch_id = (1:Nchannel_meg)'; % [N x 1]
  MEGch_id = idx;
  bexp = loaddata(1:Nchannel_meg,:,:);
  
else
  Nchannel_meg = 0;
  MEGch_id = [];
  MEGch_name = [];
  pick = [];
  Qpick = [];
  sensor_weight = [];
end

% --- EXTRA CHANNEL
ext_ch = vb_ch_info_get_channel_list_ext(ch_info);
if ~isempty(ext_ch)
  Nchannel_ext = size(ext_ch,1);
  ch_start = Nchannel_meg;
  EXTch_id = (ch_start+1):(ch_start+Nchannel_ext);
  eeg = loaddata(EXTch_id,:,:);

else
  Nchannel_ext = 0;
  EXTch_id = [];
end


% --- REFFERENCE CHANNEL
ref_ch = vb_ch_info_get_channel_list_ref(ch_info);
if ~isempty(ref_ch)
  Nchannel_ref = size(ref_ch,1);
  ch_start = Nchannel_meg+Nchannel_ext;
  REFch_id = (ch_start+1):(ch_start+Nchannel_ref);
  refmg = loaddata(REFch_id,:,:);
  
  % position
  org_ref_ch = vb_meginfo_get_channel_label_refmg(meginfo);
  [res, idx] = vb_util_check_numerical_lists(org_ref_ch, ref_ch);
  ref_pick = ref_p(idx,:);
  ref_Qpick = ref_qp(idx,:);
  
  if ~isempty(swr)
    sensor_weight_ref = swr(idx,:);
  end

else
  Nchannel_ref = 0;
  REFch_id = [];
  ref_pick = [];
  ref_Qpick = [];
  sensor_weight_ref = [];
end

% --- make new MEGinfo
MEGinfo = vb_megfile_load_meginfo(megfile);
MEGinfo.Nchannel_all      = Nchannel_all;
MEGinfo.Nchannel_org      = Nchannel_meg;
MEGinfo.Nchannel          = Nchannel_meg;

MEGinfo.sensor_weight     = sensor_weight;

MEGinfo = vb_meginfo_set_sensor_weight_refmg(MEGinfo, sensor_weight_ref);

MEGinfo.Nsample           = Nsample;
MEGinfo.Nrepeat_org       = Ntrial;
MEGinfo.Nrepeat           = Ntrial;
MEGinfo.TrialNumber       = Ntrial;
MEGinfo.MEGch_id          = MEGch_id;
MEGinfo.MEGch_name        = meg_ch;
MEGinfo.ExtraChannelInfo  = ExtraChannelInfo;
MEGinfo.saveman           = saveman;

[Measurement] = vb_megfile_get_measurement(megfile);

% 
% --- MEGinfo.EEGinfo
%
%   % header
% [org_eg, org_ns, org_sf, org_nr] = meginfo_get_eeg_header(meginfo);
% MEGinfo = meginfo_set_eeg_header(MEGinfo, org_eg, org_ns, org_sf, org_nr);
MEGinfo.EEGinfo = vb_meginfo_filter_EEGinfo(meginfo, ch_list);


% --- check existence of new file
if (exist(newfile, 'file') == 2 && overswt) ...
    || exist(newfile, 'file') ~= 2
  % save
  vb_fsave(newfile, 'MEGinfo', 'pick', 'Qpick', 'ref_pick', 'ref_Qpick', ...
    'Measurement', 'bexp', 'eeg', 'refmg');
else
  warning('(%s)cannot overwrite new MEG-MAT file : %s\n', func_, newfile);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile, ch_list, loaddata, newfile, overswt, coord_type] = ...
  inner_check_arguments(megfile, ...
    ch_list, loaddata, newfile, overswt, coord_type)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if isempty(ch_list)
  error('(%s)ch_list is a required parameter', func_);
end

if isempty(loaddata)
  error('(%s)loaddata is a required parameter', func_);
end

if isempty(newfile)
  error('(%s)newfile is a required parameter', func_);
end

if isempty(overswt)
  overswt = true;
end

if isempty(coord_type)
  % require no action
end

% --- check file
if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', megfile);
end

% --- check size
if size(vb_util_arrange_list(ch_list,1),2) ~= size(loaddata,1)
  error('(%s)channel sizes are different ch_list and loaddata', func_);
end
return;
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
