function vb_megfile_remove_noisytrial(megfile,megfile_new)
% Remove trials that is contaminated by noise. 
%
% --- Syntax
% vb_megfile_remove_noisytrial(megfile,megfile_new)
%
% --- History
% 2008-05-09 Taku Yoshioka
% 2010-01-19 (Sako) modified old fashioned code (vb_load_meg_info, vb_load_meg_data)
% 2010-01-22 (Matt) made more efficient
% 2010-01-26 (Sako) renamed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Default parameters
threshold = 9; % ratio to the median of signals
verbose = 2;   % verbose level
if nargin<1, help vb_megfile_remove_noisytrial; end

% Get information of MEG data
MEGinfo = vb_load_measurement_info(megfile);
ActTrial = vb_info_get_active_trial(MEGinfo);

ch_info = vb_load_channel_info(megfile,'AXIAL');
loadspec.ChannelName = ch_info.Name;
full_meg_data = vb_load_meg_data(megfile,loadspec);

% Create histogram
for i=1:MEGinfo.Nrepeat
  if ~ActTrial(i), continue; end
  
  meg_data = full_meg_data(:,:,i);
  
  if i==1, 
    m_max = max(abs(meg_data(:)));
    dx = m_max/100;
    x = dx:dx:m_max;
    y = hist(abs(meg_data(:)),x);
  else
    y = y+hist(abs(meg_data(:)),x);
  end
end

% Calculate threshold value
Ndata = sum(y(:));
Nmed = 0;
x = x*1e15;
for i=1:length(y)
  Nmed = Nmed+y(i);
  if Nmed>=Ndata/2, 
    th = threshold*x(i);
    break;
  end
end

% Plot histogram
bar(x,y)
yrange = ylim;
line([th th],[yrange(1) yrange(2)],'LineStyle','--','Color','k');
title('Histogram of signal amplitude');
xlabel('MEG signal [fT]');

% Show dialog to set threshold value
answer = inputdlg('Input threshold value','Threshold for noisy signal', ...
                  1,{num2str(th,'%.1f')});
close;
if isempty(answer), return; end
if ~isempty(answer{1}), th = str2num(answer{1}); end
close;

% Find noisy trials
ix_trial = [];
max_signal = [];
for i=1:MEGinfo.Nrepeat
  if ~ActTrial(i), continue; end
  
  meg_data = full_meg_data(:,:,i);
  meg_data = meg_data*1e15;

  if max(abs(meg_data(:)))>th, 
    max_signal = [max_signal; max(abs(meg_data(:)))];
    ix_trial = [ix_trial; i];
  end
end

% Remove noisy trials
for i=length(ix_trial):-1:1
  if max_signal(i)>th, 
    if verbose==2, 
      meg_data = full_meg_data(:,:,ix_trial(i));
      
      meg_data = meg_data*1e15;
      plot(meg_data(:,:)');
      title('Signal time course');
      ylabel('MEG signal [fT]');
      remove_trial = questdlg(['Remove trial ' num2str(ix_trial(i)) '?'], ...
                              'Remove trial','Yes','No','Yes');
      close;
    else
      remove_trial = 'Yes';
    end
    if strcmp(remove_trial,'Yes'), ActTrial(ix_trial(i)) = false; end
  end
end

% Update MEGinfo struct
update_spec.preprocess_parm.parm = [];
update_spec.active_trial = ActTrial;
vb_msrmnt_make_preprocessed_file(megfile,update_spec,megfile_new);

