function	[yy , tt]= vb_resample_by_spline(y, t, freq, tt)
%  resampling by spline interpolation
%  before applying this function, lowpass filtering should be done
% --- Usage
%	[yy, tt] = vb_resample_by_spline(y,t,freq)
%	yy = vb_resample_by_spline(y,t,[],tt)
% --- Input
%  y : time series data   [Nchannel x Nsample]
%  t  : time for y [sec]  [1 x Nsample]
%  freq : sampling frequency [Hz] [1 x 1]
%  tt : time for resampled data [sec] [1 x Nresample]
%  y(n, j) : n-th channel signal at time t(j), 
%            n=1:Nchannel, j=1:Nsample
% --- Output
%  yy : resampled signal at tt
%  tt : time for resampled data [sec] [1 x Nresample]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%%% DEBUG setting
%freq = 5;
%t = 0:100;  
%y = sin(t);
%%% DEBUG setting

t0 = t(1);
t1 = t(end);

if ~exist('tt','var')
	if ~isempty(freq) && length(freq)==1,
		dt = 1/freq;
		tt = t0:dt:t1;
	else
		error('No frequency nor resampled time is specified')
	end
end

[Nch, T] = size(y);

if T ~= length(t), error('dimension mismatch'); end;

yy = zeros(Nch, length(tt));

for n= 1:Nch
	yy(n,:) = spline(t,y(n,:),tt);
end

%%% DEBUG setting
%plot(tt,yy)
%%% DEBUG setting
