function	[Y, Z] = vb_online_filter(A, B, C, D, X, Z)
% Online filter calculation
% [Y, Z] = vb_online_filter(A, B, C, D, X, Z)
% [A, B, C, D] : filter matrix
% X : Input signal (Nch x 1)
% Z : Internal state variable (Nch x Norder)
% Y : Output signal  (Nch x 1)
%
% Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%	[A, B, C, D] = butter(Norder, freq/(fsamp/2));
%	A = A'; B = B'; C = C'; D = D';
%	A: Norder x Norder, 
%	B: 1 x Norder, 
%	C: Norder x 1, 
%	D: 1 x 1
%	Y = Z * C + U * D; % Output update
%	Z = Z * A + U * B; % Internal state variable update

Y = Z * C + X * D;
Z = Z * A + X * B;

