function	vb_fprint_filter_parm(parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if  ~isempty(parm.bias_flg) 
	if parm.bias_flg > 5,
		fprintf('Bias correction by first %d sample\n',parm.bias_flg)
	elseif parm.bias_flg > 0
		fprintf('Bias correction mode = %d\n',parm.bias_flg)
	end
end
if ~isempty(parm.highpass),
	% Highpass cutoff frequency
	fcut = parm.highpass; 
	
	if isfield(parm,'highpass_online') 
		Norder = parm.highpass_online;
		
		if Norder == 1
			% Exponential online highpass filter
			fprintf('Online highpass filter %6.1f [Hz]\n',fcut)
		elseif Norder > 1
			fprintf('butter filtfilt highpass filter %6.1f [Hz]\n',fcut)
		elseif Norder < 0
			fprintf('Online butter highpass filter %6.1f [Hz]\n',fcut)
		end
	end
	if ~isfield(parm,'highpass_online') || parm.highpass_online==0
		fprintf('FIR Highpass filter %6.1f [Hz]\n',fcut)
	end
end
% Lowpass filter
if ~isempty(parm.lowpass)
	fcut = parm.lowpass;
	
	if isfield(parm,'lowpass_online') 
		% Online Butterworth filter
		Norder = parm.lowpass_online; % filter order
		if Norder > 0
			fprintf('butter filtfilt lowpass filter %6.1f [Hz]\n',fcut)
		elseif Norder < 0
			fprintf('Online butter lowpass filter %6.1f [Hz]\n',fcut)
		end
	end
	if ~isfield(parm,'lowpass_online') || parm.lowpass_online==0
		% FIR Lowpass filter
		fprintf('FIR Lowpass filter %6.1f [Hz]\n', fcut)
	end
end

% Down sampling
if isfield(parm,'fsamp') && ~isempty(parm.fsamp)
	fsnew = parm.fsamp;
	fprintf('Down sampling to %6.1f [Hz]\n',fsnew)
end

% Common reference
if isfield(parm,'common_flg') && ~isempty(parm.common_flg) ...
	&& parm.common_flg==1
	fprintf('Common reference\n')
end
