function EEGinfo = vb_eeginfo_set_sensor_position(EEGinfo, position)
% set sensor position data to EEGinfo struct
% [usage]
%   EEGinfo = vb_eeginfo_set_sensor_position( EEGinfo, position )
% [input]
%    EEGinfo : <required> EEGinfo struct data
%   position : <optional> 3-D coordinates of sensor [n_sensor x 3] []
% [output]
%    EEGinfo : updated EEGinfo
% [note]
%   @see vb_eeginfo_get_sensor_position
% [history]
%   2006-12-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('EEGinfo', 'var'), EEGinfo = []; end
if ~exist('position', 'var'), position = []; end
[EEGinfo, position] = inner_check_arguments(EEGinfo, position);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
EEGinfo.Coord = position;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [EEGinfo, position] = inner_check_arguments(EEGinfo, position)
func_ = mfilename;
if isempty(EEGinfo)
  error('(%s)EEGinfo is a required parameter', func_);
end

if isempty(position)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
