function [version] = vb_eeginfo_get_version(eeginfo)
% return version data from EEGinfo
% [usage]
%   [version] = vb_eeginfo_get_version(eeginfo)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
% [output]
%   version : version data
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
version = [];

if isfield(eeginfo, 'device_info')
  if isfield(eeginfo.device_info, 'Version')
    version = eeginfo.device_info.Version;
  else
%     warning('device_info does not have ''Version'' field\n');
  end
else
  if isfield(eeginfo, 'Version')
    version = eeginfo.Version;
  else
%     warning('eeginfo does not have ''Version'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;

if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
