function [n_sample] = vb_eeginfo_get_sample_number(eeginfo)
% <<getter>> return number of sample from EEGinfo
% [usage]
%   [n_sample] = vb_eeginfo_get_sample_number(eeginfo)
% [input]
%    eeginfo : <required> <<struct>> EEGinfo
% [output]
%   n_sample : number of sample
% [note]
%
% [history]
%   2008-02-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'Nsample')
  n_sample = 0;
else
  n_sample = eeginfo.Nsample;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %



%%% END OF FILE %%%
