function [reference] = vb_eeginfo_get_reference(eeginfo)
% return reference data from EEGinfo
% [usage]
%   [reference] = vb_eeginfo_get_reference(eeginfo)
% [input]
%     eeginfo : <required> <<struct>> EEGinfo
% [output]
%   reference : sensor reference type
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
reference = [];

if isfield(eeginfo, 'device_info')
  if isfield(eeginfo.device_info, 'Reference')
    reference = eeginfo.device_info.Reference;
  else
%     warning('device_info does not have ''Reference'' field\n');
  end
else
  if isfield(eeginfo, 'Reference')
    reference = eeginfo.Reference;
  else
%     warning('eeginfo does not have ''Reference'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;

if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
