function [rec_time] = vb_eeginfo_get_rectime(eeginfo)
% return record time from EEGinfo
% [usage]
%   [rec_time] = vb_eeginfo_get_rectime(eeginfo)
% [input]
%    eeginfo : <required> <<struct>> EEGinfo
% [output]
%   rec_time : record time [sec]
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
rec_time = [];

if isfield(eeginfo, 'device_info')
  if isfield(eeginfo.device_info, 'RecordTime')
    rec_time = eeginfo.device_info.RecordTime;
  else
%     warning('device_info does not have ''RecordTime'' field\n');
  end
else
  if isfield(eeginfo, 'RecordTime')
    rec_time = eeginfo.RecordTime;
  else
%     warning('eeginfo does not have ''RecordTime'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;

if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
