function [posttrigger] = vb_eeginfo_get_post_trigger(EEGinfo)
% return post-trigger from current EEGinfo struct
% [usage]
%   [posttrigger] = vb_eeginfo_get_post_trigger(EEGinfo)
% [input]
%      EEGinfo : <required> <<struct>> EEG information
% [output]
%   posttrigger : post-trigger value of current EEGinfo
% [note]
%   
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('EEGinfo', 'var') EEGinfo = []; end
[EEGinfo] = inner_check_arguments(EEGinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
posttrigger = EEGinfo.Posttrigger;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [EEGinfo] = inner_check_arguments(EEGinfo)

func_ = mfilename;
if isempty(EEGinfo)
  error('(%s)EEGinfo is a required parameter', func_);
end

if ~isfield(EEGinfo, 'Posttrigger')
  EEGinfo.Posttrigger = [];
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
