function [eeginfo] = vb_eegfile_load_eeginfo(eegfile)
% return EEGinfo in EEG-MAT file
%
% [usage]
%   [eeginfo] = vb_eegfile_load_eeginfo(eegfile)
%
% [input]
%   eegfile : <required> <<file>> EEG-MAT file
%
% [output]
%   eeginfo : <<struct>> EEG header information
%
% [note]
%
% [history]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eegfile', 'var'), eegfile = []; end
[eegfile] = inner_check_arguments(eegfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
load(eegfile, 'EEGinfo');

if ~exist('EEGinfo', 'var')
  warning('(%s)cannot find EEGinfo in this file: %s\n', mfilename, eegfile);
  eeginfo = [];
else
  eeginfo = EEGinfo;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile] = inner_check_arguments(eegfile)
func_ = mfilename;
if isempty(eegfile)
  error('(%s)eegfile is a required parameter', func_);
end

if exist(eegfile, 'file') ~= 2
  error('(%s)cannot find eegfile : %s', func_, eegfile);
end
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
